//
//  DHDMXPacket.h
//  DHDMX
//
//  Created by Douglas Heriot on 9/04/12.
//  Copyright (c) 2012 Douglas Heriot Design. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface DHDMXPacket : NSObject <NSCoding, NSCopying>
{
	NSData *_data;
	NSData *_address;
}

@property (copy, nonatomic, readonly) NSData *data;
@property (copy, nonatomic, readonly) NSData *address;

- (id)initWithData:(NSData *)data;
- (id)initWithData:(NSData *)data address:(NSData *)address;

// Override to validate minimum length in init
@property (readonly, nonatomic) NSUInteger minLength;

@end
